/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.richtext.v2_1;

import com.roguewave.chart.richtext.v2_1.BlockContext;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import java.awt.Font;
import java.awt.Graphics;

public class FontBlock
implements TextBlock {
    TextBlock block_;
    Font font_ = null;
    int style_;
    int size_ = -1;
    boolean combine_ = true;
    boolean initDone_ = false;
    int initWidth_;
    int initHeight_;
    int initAscent_;
    BlockContext initContext_;

    public FontBlock(TextBlock block, Font font) {
        this.block_ = block;
        this.font_ = font;
    }

    public FontBlock(TextBlock block, int style) {
        this.block_ = block;
        this.style_ = style;
    }

    public FontBlock(TextBlock block, int style, boolean combine) {
        this.block_ = block;
        this.style_ = style;
        this.combine_ = combine;
    }

    public FontBlock(TextBlock block, int style, int size) {
        this.block_ = block;
        this.style_ = style;
        this.size_ = size;
    }

    public int getAscent(BlockContext bc) {
        if (this.initDone_) {
            return this.initAscent_;
        }
        BlockContext newbc = bc.create();
        Graphics gc = newbc.getGraphics().create();
        if (this.font_ != null) {
            gc.setFont(this.font_);
        } else {
            Font oldFont = gc.getFont();
            int style = this.combine_ ? oldFont.getStyle() + this.style_ : this.style_;
            int size = this.size_ < 0 ? oldFont.getSize() : this.size_;
            Font font = new Font(oldFont.getName(), style, size);
            gc.setFont(font);
        }
        newbc.setGraphics(gc);
        return this.block_.getAscent(newbc);
    }

    public int getWidth(BlockContext bc) {
        if (this.initDone_) {
            return this.initWidth_;
        }
        BlockContext newbc = bc.create();
        Graphics gc = newbc.getGraphics().create();
        if (this.font_ != null) {
            gc.setFont(this.font_);
        } else {
            Font oldFont = gc.getFont();
            int style = this.combine_ ? oldFont.getStyle() + this.style_ : this.style_;
            int size = this.size_ < 0 ? oldFont.getSize() : this.size_;
            Font font = new Font(oldFont.getName(), style, size);
            gc.setFont(font);
        }
        newbc.setGraphics(gc);
        return this.block_.getWidth(newbc);
    }

    public int getHeight(BlockContext bc) {
        if (this.initDone_) {
            return this.initHeight_;
        }
        BlockContext newbc = bc.create();
        Graphics gc = newbc.getGraphics().create();
        if (this.font_ != null) {
            gc.setFont(this.font_);
        } else {
            Font oldFont = gc.getFont();
            int style = this.combine_ ? oldFont.getStyle() + this.style_ : this.style_;
            int size = this.size_ < 0 ? oldFont.getSize() : this.size_;
            Font font = new Font(oldFont.getName(), style, size);
            gc.setFont(font);
        }
        newbc.setGraphics(gc);
        return this.block_.getHeight(newbc);
    }

    public void init(BlockContext bc) {
        this.initContext_ = bc.create();
        Graphics gc = this.initContext_.getGraphics().create();
        if (this.font_ != null) {
            gc.setFont(this.font_);
        } else {
            Font oldFont = gc.getFont();
            int style = this.combine_ ? oldFont.getStyle() + this.style_ : this.style_;
            int size = this.size_ < 0 ? oldFont.getSize() : this.size_;
            Font font = new Font(oldFont.getName(), style, size);
            gc.setFont(font);
        }
        this.initContext_.setGraphics(gc);
        this.block_.init(this.initContext_);
        this.initHeight_ = this.block_.getHeight(this.initContext_);
        this.initWidth_ = this.block_.getWidth(this.initContext_);
        this.initAscent_ = this.block_.getAscent(this.initContext_);
        this.initDone_ = true;
    }

    public void render(BlockContext bc) {
        if (this.initDone_) {
            this.initContext_.setX(bc.getX());
            this.initContext_.setY(bc.getY());
            this.block_.render(this.initContext_);
            return;
        }
        BlockContext newbc = bc.create();
        Graphics gc = newbc.getGraphics().create();
        if (this.font_ != null) {
            gc.setFont(this.font_);
        } else {
            Font oldFont = gc.getFont();
            int style = this.combine_ ? oldFont.getStyle() + this.style_ : this.style_;
            int size = this.size_ < 0 ? oldFont.getSize() : this.size_;
            Font font = new Font(oldFont.getName(), style, size);
            gc.setFont(font);
        }
        newbc.setGraphics(gc);
        this.block_.render(newbc);
    }
}

